#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct Point {
    long long x, y;
    
    // Pomocna funkcija za sortiranje tacaka
    bool operator < (const Point &p) const {
        if (x == p.x) return y < p.y;
        return x < p.x;
    }
};

// Funkcija koja racuna vektorski proizvod (cross product)
long long crossProduct(const Point &O, const Point &A, const Point &B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

// Funkcija koja izracunava površinu konveksnog mnogougla pomocu shoelace formule
long long polygonArea(const vector<Point> &hull) {
    long long area = 0;
    int n = hull.size();
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        area += hull[i].x * hull[j].y;
        area -= hull[j].x * hull[i].y;
    }
    return abs(area) / 2;
}

// Funkcija koja racuna konveksni omotac koristeci Grahamovu skener
vector<Point> convexHull(vector<Point> &points) {
    sort(points.begin(), points.end());

    vector<Point> lower, upper;
    
    // Donja polovina omotaca
    for (auto &p : points) {
        while (lower.size() >= 2 && crossProduct(lower[lower.size() - 2], lower[lower.size() - 1], p) <= 0) {
            lower.pop_b